/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.model.CamoBakedModel;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public abstract class CamoBlockEntity
extends BaseTileEntity {
    private BlockState camoState = Blocks.f_50016_.m_49966_();

    public CamoBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public boolean setCamoState(BlockState state) {
        this.camoState = state == null ? Blocks.f_50016_.m_49966_() : state;
        this.dataChanged();
        this.f_58857_.m_5518_().m_142202_(this.f_58858_);
        this.requestModelDataUpdate();
        return true;
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    public boolean hasCamoState() {
        return this.camoState != null && this.camoState.m_60734_() != Blocks.f_50016_;
    }

    public boolean canBeCamoStack(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        Block block = ((BlockItem)stack.m_41720_()).m_40614_();
        return !MovingElevators.CAMOUFLAGE_MOD_BLACKLIST.contains(block.getRegistryName().m_135827_()) && this.isFullCube(block.m_49966_());
    }

    private boolean isFullCube(BlockState state) {
        List shapes = state.m_60812_((BlockGetter)this.f_58857_, this.f_58858_).m_83299_();
        return shapes.size() == 1 && ((AABB)shapes.get(0)).equals((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(CamoBakedModel.CAMO_PROPERTY, (Object)(this.hasCamoState() ? this.camoState : null)).build();
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("camoState", Block.m_49956_((BlockState)this.camoState));
        return compound;
    }

    protected void readData(CompoundTag compound) {
        ItemStack camoStack;
        Item item;
        if (compound.m_128441_("camoState")) {
            this.camoState = Block.m_49803_((int)compound.m_128451_("camoState"));
        } else if (compound.m_128441_("hasCamo")) {
            this.camoState = compound.m_128471_("hasCamo") ? Block.m_49803_((int)compound.m_128451_("camo")) : Blocks.f_50016_.m_49966_();
        } else if (compound.m_128441_("camo") && (item = (camoStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("camo"))).m_41720_()) instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            this.camoState = block.m_49966_();
        }
    }

    public void m_142466_(CompoundTag nbt) {
        if (nbt.m_128425_("info", 10)) {
            nbt.m_128365_("data", (Tag)nbt.m_128469_("info"));
            nbt.m_128473_("info");
        }
        super.m_142466_(nbt);
    }
}

